/*C**************************************************************************
* NAME:         kbd_drv.c
*----------------------------------------------------------------------------
* Copyright (c) 2003 Atmel.
*----------------------------------------------------------------------------
* RELEASE:      c5131-usb-kbd-light-1_0_2      
* REVISION:     1.1     
*----------------------------------------------------------------------------
* PURPOSE: 
* This file contains C functions to control:
* SWITCHES
*****************************************************************************/

/*_____ I N C L U D E S ____________________________________________________*/
#include "config.h"
#include "kbd_drv.h"

/*_____ M A C R O S ________________________________________________________*/

/*_____ D E F I N I T I O N S ______________________________________________*/
#define KBD_COL_MASK            0x0F
#define KBD_COL0                0x08
#define KBD_COL1                0x04
#define KBD_COL2                0x02
#define KBD_COL3                0x01
#define KBD_ROW_MASK            0xF0
#define KBD_ROW0                0x10
#define KBD_ROW1                0x20
#define KBD_ROW2                0x40
#define KBD_ROW3                0x80

#define DEFAULT_SWITCHES_VALUE  0xFF
#define DEFAULT_SCAN_KEY_VALUE  0
/*_____ D E C L A R A T I O N S ____________________________________________*/


/*V**************************************************************************
* NAME: scan_key
*----------------------------------------------------------------------------
* PURPOSE: 
* scan_key is a structure allowing easy byte/word access (Union16).
* 16 keys on keypad in a 16-bit variable => all cases supported
* Ex. for geneb:
* MSb                         LSb
* 9 5 1 < * 6 2 > 0 7 3 V # 8 4 C
*****************************************************************************/
volatile Union16 idata  scan_key;
Byte code               geneb_keys[]= { 'C', '4', '8', '#',
                                        'V', '3', '7', '0',
                                        '>', '2', '6', '*',
                                        '<', '1', '5', '9'  };
void kbd_test_hit (void)
{


}


bit kbd_init (void)
{
  return 0;
}






